<?php
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "include/includeBase.php";
    include "../gUtil/GeneratoreEmail.php";

    session_start();
    //controllo di sicurezza, verifica che l'utente sta inviando i campi dalla pagina index.php
    if(!isset($_POST["tokenSicurezza"]) || !isset($_SESSION["tokenSicurezza"])) {
        header("Location: index.php?status=444");
    }
    else if ($_POST["tokenSicurezza"]!= $_SESSION["tokenSicurezza"]) {
        unset($_SESSION["tokenSicurezza"]);
        header("Location: index.php?status=444");
    }
    else {
        unset($_SESSION["tokenSicurezza"]);
        
        //dati admin
        $email    = filter_input(INPUT_POST,"email",FILTER_SANITIZE_ADD_SLASHES);
        $password = hash("sha512",$_POST['password']);

        $queryLogin = "SELECT * FROM geec_utenti WHERE email LIKE '$email' AND password LIKE '$password' AND (ruolo LIKE 'super admin' OR ruolo LIKE 'amministratore' OR ruolo LIKE 'autore')";
        $result = $geecomDb->eseguiQueryLettura($queryLogin);
        if($result->num_rows>0) {
            $admin = $result->fetch_array(MYSQLI_ASSOC);

            if($admin["stato"]=="non attivato") {
                header("Location: index.php?status=401");                    
            }
            else {
                $arrayIndirizzoSito = explode("//",$impostazioni["urlSito"]);
                $indirizzoSito = str_replace("www.","",$arrayIndirizzoSito[1]);
                $emailMittente = "geecom@$indirizzoSito";

                //se ha creato l'utente invia una mail con i dati dell'account
                $generatoreEmail = new GeneratoreEmail("Geecom CMS", $emailMittente);

                if($impostazioni["inviaMailLogin"]=="si") {

                    $oggetto = "È stato effettuato l'accesso al tuo sito {$impostazioni["titoloSito"]}";
                    $messaggio = "Ciao {$admin["nome"]},<br> questa è una notifica di connessione automatica che ti segnala che è stato effettuato l'accesso al tuo sito con 
                        il seguente indirizzo ip: {$_SERVER['REMOTE_ADDR']}.<br> 
                                  Se non vuoi ricevere queste notifiche, vai nella sezione impostazioni di Geecom, clicca su sicurezza e deseleziona <b>invia mail al login</b>";

                    $generatoreEmail->invia($email, $oggetto, $messaggio);
                }

                if($impostazioni["loginADueFasi"]=="si") {

                    //genero la password temporanea
                    $passwordTemporanea = "";
                    for($i=0;$i<7;$i++) {
                        $num = rand(0,51);
                        $a_z = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
                        $passwordTemporanea = $passwordTemporanea.$a_z[$num];
                    }

                    $_SESSION["passwordTemporanea"] = $passwordTemporanea;
                    $_SESSION["idUtente"]           = $admin["id"];

                    $oggetto = "La tua password temporanea per accedere al tuo sito {$impostazioni["titoloSito"]}";
                    $messaggio = "Ciao {$admin["nome"]},<br> inserisci la password <strong>$passwordTemporanea</strong> per accedere al tuo sito";

                    $generatoreEmail->invia($email, $oggetto, $messaggio);
                    header("Location: inserisciPasswordLoginADueFasi.php");
                }
                else {

                    $_SESSION["geecomAdmin_id"]    = $admin["id"];
                    $_SESSION["geecomAdmin_email"] = $admin["email"];
                    $_SESSION["geecomAdmin_ruolo"] = $admin["ruolo"];
                    $nomeAdmin = explode(" ",$admin["nome"]); 
                    $_SESSION["geecomAdmin_nome"] = $nomeAdmin[0]; //prendo solo il primo nome, che verrà mostrato in alto a destra 
                    $_SESSION["geecomAdmin_nomeCognome"] = $admin["nome"]." ".$admin["cognome"]; //usato quando si inserisce un nuovo contenuto

                    if($admin["stato"]=="non attivato") {
                        header("Location: index.php?status=401");                    
                    }
                    else {                
                        header("Location: home.php");
                    }
                }
            }
        }
        else {
            header("Location: index.php?status=400");
        }
    }